<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// DBSEO "SocialGroup URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroup
{
	public static $format = 'SocialGroup_SocialGroup';
	public static $structure = 'group.php?groupid=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		if ($urlInfo['group_name'] AND !$urlInfo['group_id'])
		{
			// Reverse group name
			$urlInfo['group_id'] = DBSEO::reverseObject('group', $urlInfo['group_name']);
		}

		// Return the constructed URL
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['group_id'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		// Shorthand
		$data['groupid'] = $data['groupid'] ? $data['groupid'] : $data['g'];
		if (!$data['groupid'])
		{
			// Groupid didn't exist
			return '';
		}

		// Get group info here
		$groupInfo = self::getInfo($data['groupid']);

		if (!$groupInfo['groupid'])
		{
			// Groupid didn't exist
			return '';
		}

		if (!isset($groupInfo['seotitle']))
		{
			$groupInfo['seotitle'] = DBSEO::filterText($groupInfo['name'], NULL, true, (strpos($rawFormat, 'group_id') === false));
			if (preg_match('#[-_\s](?:post|print)?\d+$#', $groupInfo['seotitle']) OR !$groupInfo['seotitle'])
			{
				// Append what we need to the title
				$groupInfo['seotitle'] .= ($groupInfo['seotitle'] ? DBSEO::$config['dbtech_dbseo_rewrite_separator'] : '') . 'a';
			}

			// Set this
			DBSEO::$cache['socialgroup'][$groupInfo['groupid']]['seotitle'] = $groupInfo['seotitle'];
		}

		// Handle group info
		$replace['%group_id%'] 		= $groupInfo['groupid'];
		$replace['%group_name%'] 	= $groupInfo['seotitle'];

		if ($data['page'])
		{
			// We had a paged group
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}

	/**
	 * Gets any extra information needed
	 *
	 * @param mixed $socialGroupIds
	 * 
	 * @return array
	 */
	public static function getInfo($socialGroupIds)
	{
		$socialGroupInfo = array();

		if (!is_array($socialGroupIds))
		{
			// Ensure this is an array
			$socialGroupIds = array($socialGroupIds);
		}

		foreach ($socialGroupIds as $key => $id)
		{
			if (($info = DBSEO::$datastore->fetch('sginfo.' . $id)) === false)
			{
				// We don't have this cached
				continue;
			}

			// We had this cached, cache it internally too
			DBSEO::$cache['socialgroup'][$id] = $info;
		}

		$queryList = array();
		foreach ($socialGroupIds as $key => $socialGroupId)
		{
			if (!isset(DBSEO::$cache['socialgroup'][$socialGroupId]))
			{
				// Ensure this is done
				$queryList[$key] = intval($socialGroupId);
			}
		}

		if (count($queryList))
		{
			$info = DBSEO::$db->generalQuery('
				SELECT *
				FROM $socialgroup
				WHERE groupid IN(' . implode(',', $queryList) . ')
			', false);
			foreach ($info as $arr)
			{
				// Build the cache
				DBSEO::$datastore->build('sginfo.' . $arr['groupid'], $arr);

				// Cache this info
				DBSEO::$cache['socialgroup'][$arr['groupid']] = $arr;
			}
		}

		if (count($socialGroupIds) == 1)
		{
			// We have only one, return only one
			$socialGroupInfo = DBSEO::$cache['socialgroup'][$socialGroupIds[0]];
		}
		else
		{
			foreach ($socialGroupIds as $key => $socialGroupId)
			{
				// Create this array
				$socialGroupInfo[$socialGroupId] = DBSEO::$cache['socialgroup'][$socialGroupId];
			}
		}

		return $socialGroupInfo;
	}
}


// #############################################################################
// DBSEO "SocialGroup URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroup_Page extends DBSEO_Rewrite_SocialGroup
{
	public static $format = 'SocialGroup_SocialGroup_Page';
	public static $structure = 'group.php?groupid=%d&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}

// #############################################################################
// DBSEO "SocialGroupDiscussion URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupDiscussion
{
	public static $format = 'SocialGroup_SocialGroupDiscussion';
	public static $structure = 'group.php?discussionid=%d&do=discuss';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Return the constructed URL
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['discussion_id'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		// Shorthand
		$data['discussionid'] = $data['discussionid'] ? $data['discussionid'] : $data['d'];

		if ($data['gmid'] AND !$data['discussionid'])
		{
			// Get group info here
			$groupMessage = self::getGroupMessageInfo($data['gmid']);
			$data['discussionid'] = $groupMessage['discussionid'];
		}

		if (!$data['discussionid'])
		{
			// discussionid didn't exist
			return '';
		}

		// Get group info here
		$discussionInfo = self::getInfo($data['discussionid']);

		if (!$discussionInfo['discussionid'])
		{
			// Groupid didn't exist
			return '';
		}

		// Handle group info
		$replace['%discussion_id%'] 	= $discussionInfo['discussionid'];
		$replace['%discussion_name%'] 	= DBSEO::filterText($discussionInfo['title'], NULL, true, true);

		// Shorthand
		$data['groupid'] = $discussionInfo['groupid'];
		if (!$data['groupid'])
		{
			// Groupid didn't exist
			return '';
		}

		// Get group info here
		$groupInfo = DBSEO_Rewrite_SocialGroup::getInfo($data['groupid']);

		if (!$groupInfo['groupid'])
		{
			// Groupid didn't exist
			return '';
		}

		if (!isset($groupInfo['seotitle']))
		{
			$groupInfo['seotitle'] = DBSEO::filterText($groupInfo['name'], NULL, true, (strpos($rawFormat, 'group_id') === false));
			if (preg_match('#[-_\s](?:post|print)?\d+$#', $groupInfo['seotitle']) OR !$groupInfo['seotitle'])
			{
				// Append what we need to the title
				$groupInfo['seotitle'] .= ($groupInfo['seotitle'] ? DBSEO::$config['dbtech_dbseo_rewrite_separator'] : '') . 'a';
			}

			// Set this
			DBSEO::$cache['socialgroup'][$groupInfo['groupid']]['seotitle'] = $groupInfo['seotitle'];
		}

		// Handle group info
		$replace['%group_id%'] 		= $groupInfo['groupid'];
		$replace['%group_name%'] 	= $groupInfo['seotitle'];

		if ($data['page'])
		{
			// We had a paged group
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}

	/**
	 * Gets any extra information needed
	 *
	 * @param mixed $discussionIds
	 * 
	 * @return array
	 */
	public static function getInfo($discussionIds)
	{
		$discussionInfo = array();

		if (!is_array($discussionIds))
		{
			// Ensure this is an array
			$discussionIds = array($discussionIds);
		}

		foreach ($discussionIds as $key => $id)
		{
			if (($info = DBSEO::$datastore->fetch('sgdiscinfo.' . $id)) === false)
			{
				// We don't have this cached
				continue;
			}

			// We had this cached, cache it internally too
			DBSEO::$cache['socialgroupdiscussion'][$id] = $info;
		}

		$queryList = array();
		foreach ($discussionIds as $key => $discussionId)
		{
			if (!isset(DBSEO::$cache['socialgroupdiscussion'][$discussionId]))
			{
				// Ensure this is done
				$queryList[$key] = intval($discussionId);
			}
		}

		if (count($queryList))
		{
			$info = DBSEO::$db->generalQuery('
				SELECT discussion.*, groupmessage.title
				FROM $discussion AS discussion
				LEFT JOIN $groupmessage AS groupmessage ON(groupmessage.gmid = discussion.firstpostid)
				WHERE discussion.discussionid IN(' . implode(',', $queryList) . ')
			', false);
			foreach ($info as $arr)
			{
				// Build the cache
				DBSEO::$datastore->build('sgdiscinfo.' . $arr['discussionid'], $arr);

				// Cache this info
				DBSEO::$cache['socialgroupdiscussion'][$arr['discussionid']] = $arr;
			}
		}

		if (count($discussionIds) == 1)
		{
			// We have only one, return only one
			$discussionInfo = DBSEO::$cache['socialgroupdiscussion'][$discussionIds[0]];
		}
		else
		{
			foreach ($discussionIds as $key => $discussionId)
			{
				// Create this array
				$discussionInfo[$discussionId] = DBSEO::$cache['socialgroupdiscussion'][$discussionId];
			}
		}

		return $discussionInfo;
	}

	/**
	 * Gets any extra information needed
	 *
	 * @param mixed $groupMessageIds
	 * 
	 * @return array
	 */
	public static function getGroupMessageInfo($groupMessageIds)
	{
		$groupMessageInfo = array();

		if (!is_array($groupMessageIds))
		{
			// Ensure this is an array
			$groupMessageIds = array($groupMessageIds);
		}

		foreach ($groupMessageIds as $key => $id)
		{
			if (($info = DBSEO::$datastore->fetch('gminfo.' . $id)) === false)
			{
				// We don't have this cached
				continue;
			}

			// We had this cached, cache it internally too
			DBSEO::$cache['groupmessage'][$id] = $info;
		}

		$queryList = array();
		foreach ($groupMessageIds as $key => $groupMessageId)
		{
			if (!isset(DBSEO::$cache['groupmessage'][$groupMessageId]))
			{
				// Ensure this is done
				$queryList[$key] = intval($groupMessageId);
			}
		}

		if (count($queryList))
		{
			$info = DBSEO::$db->generalQuery('
				SELECT *
				FROM $groupmessage AS groupmessage
				WHERE gmid IN(' . implode(',', $queryList) . ')
			', false);
			foreach ($info as $arr)
			{
				// Build the cache
				DBSEO::$datastore->build('gminfo.' . $arr['gmid'], $arr);

				// Cache this info
				DBSEO::$cache['groupmessage'][$arr['gmid']] = $arr;
			}
		}

		if (count($groupMessageIds) == 1)
		{
			// We have only one, return only one
			$groupMessageInfo = DBSEO::$cache['groupmessage'][$groupMessageIds[0]];
		}
		else
		{
			foreach ($groupMessageIds as $key => $groupMessageId)
			{
				// Create this array
				$groupMessageInfo[$groupMessageId] = DBSEO::$cache['groupmessage'][$groupMessageId];
			}
		}

		return $groupMessageInfo;
	}
}

// #############################################################################
// DBSEO "SocialGroupDiscussion URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupDiscussion_Page extends DBSEO_Rewrite_SocialGroupDiscussion
{
	public static $format = 'SocialGroup_SocialGroupDiscussion_Page';
	public static $structure = 'group.php?discussionid=%d&do=discuss&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}

// #############################################################################
// DBSEO "SocialGroupDiscussion URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupDiscussion_LastPost extends DBSEO_Rewrite_SocialGroupDiscussion
{
	public static $format = 'SocialGroup_SocialGroupDiscussion_LastPost';
	public static $structure = 'group.php?gmid=%d&do=discuss#gmessage%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Return the constructed URL
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['gmid'], $urlInfo['gmid']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "SocialGroupList URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupList
{
	public static $format = 'SocialGroup_SocialGroupList';
	public static $structure = 'group.php?do=grouplist';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Return the constructed URL
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "SocialGroupList URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupList_Page extends DBSEO_Rewrite_SocialGroupList
{
	public static $format = 'SocialGroup_SocialGroupList_Page';
	public static $structure = 'group.php?do=grouplist&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}

// #############################################################################
// DBSEO "SocialGroupMembers URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupMembers extends DBSEO_Rewrite_SocialGroup
{
	public static $format = 'SocialGroup_SocialGroupMembers';
	public static $structure = 'group.php?groupid=%d&do=viewmembers';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}

// #############################################################################
// DBSEO "SocialGroupMembers URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupMembers_Page extends DBSEO_Rewrite_SocialGroupMembers
{
	public static $format = 'SocialGroup_SocialGroupMembers_Page';
	public static $structure = 'group.php?groupid=%d&do=viewmembers&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}

// #############################################################################
// DBSEO "SocialGroupPictures URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupPictures extends DBSEO_Rewrite_SocialGroup
{
	public static $format = 'SocialGroup_SocialGroupPictures';
	public static $structure = 'group.php?groupid=%d&do=grouppictures';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}

// #############################################################################
// DBSEO "SocialGroupPictures URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupPictures_Page extends DBSEO_Rewrite_SocialGroupPictures
{
	public static $format = 'SocialGroup_SocialGroupPictures_Page';
	public static $structure = 'group.php?groupid=%d&do=grouppictures&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}

// #############################################################################
// DBSEO "SocialGroupPicture URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupPicture
{
	public static $format = 'SocialGroup_SocialGroupPicture';
	public static $structure = 'group.php?do=picture&groupid=%d&%s=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		if ($urlInfo['group_name'] AND !$urlInfo['group_id'])
		{
			// Reverse group name
			$urlInfo['group_id'] = DBSEO::reverseObject('group', $urlInfo['group_name']);
		}

		// Return the constructed URL
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['group_id'], DBSEO::$config['_pictureid'], $urlInfo['picture_id'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		if ($data[DBSEO::$config['_pictureid']])
		{
			// Grab group picture info
			$groupPictureInfo = DBSEO::getObjectInfo(DBSEO::$config['_picturestorage'], $data[DBSEO::$config['_pictureid']]);
		}

		if (!$groupPictureInfo[DBSEO::$config['_pictureid']])
		{
			// group picture didn't exist
			return '';
		}

		// Handle picture id and picture title
		$replace['%picture_id%'] 	= $groupPictureInfo[DBSEO::$config['_pictureid']];
		$replace['%picture_title%'] = DBSEO::filterText($groupPictureInfo['caption']);

		$data['groupid'] = ($data['groupid'] ? $data['groupid'] : DBSEO::getContentId($groupPictureInfo));
		if ($data['groupid'])
		{
			// Get group info here
			$groupInfo = DBSEO_Rewrite_SocialGroup::getInfo($data['groupid']);
		}

		if (!$groupInfo['groupid'])
		{
			// Groupid didn't exist
			return '';
		}

		if (!isset($groupInfo['seotitle']))
		{
			$groupInfo['seotitle'] = DBSEO::filterText($groupInfo['name'], NULL, true, (strpos($rawFormat, 'group_id') === false));
			if (preg_match('#[-_\s](?:post|print)?\d+$#', $groupInfo['seotitle']) OR !$groupInfo['seotitle'])
			{
				// Append what we need to the title
				$groupInfo['seotitle'] .= ($groupInfo['seotitle'] ? DBSEO::$config['dbtech_dbseo_rewrite_separator'] : '') . 'a';
			}

			// Set this
			DBSEO::$cache['socialgroup'][$groupInfo['groupid']]['seotitle'] = $groupInfo['seotitle'];
		}

		// Handle group info
		$replace['%group_id%'] 		= $groupInfo['groupid'];
		$replace['%group_name%'] 	= $groupInfo['seotitle'];

		if ($data['page'])
		{
			// We had a paged group
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "SocialGroupPicture URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupPicture_Page extends DBSEO_Rewrite_SocialGroupPicture
{
	public static $format = 'SocialGroup_SocialGroupPicture_Page';
	public static $structure = 'group.php?do=picture&groupid=&d&%s=%d&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}

// #############################################################################
// DBSEO "SocialGroupCategoryList URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupCategoryList
{
	public static $format = 'SocialGroup_SocialGroupCategoryList';
	public static $structure = 'group.php?do=categorylist';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Return the constructed URL
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "SocialGroupCategoryList URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupCategoryList_Page extends DBSEO_Rewrite_SocialGroupCategoryList
{
	public static $format = 'SocialGroup_SocialGroupCategoryList_Page';
	public static $structure = 'group.php?do=categorylist&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}

// #############################################################################
// DBSEO "SocialGroupCategory URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupCategory
{
	public static $format = 'SocialGroup_SocialGroupCategory';
	public static $structure = 'group.php?cat=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		if ($urlInfo['cat_name'] AND !$urlInfo['cat_id'])
		{
			// Reverse the category object
			$urlInfo['cat_id'] = DBSEO::reverseObject('groupcat', $urlInfo['cat_name']);
		}

		// Return the constructed URL
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['cat_id'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		$data['categoryid'] = $data['cat'] ? $data['cat'] : $data['categoryid'];
		if (!$data['categoryid'])
		{
			return '';
		}

		// Get group info here
		$groupCategoryInfo = self::getInfo($data['categoryid']);

		if (!$groupCategoryInfo['categoryid'])
		{
			// Groupid didn't exist
			return '';
		}

		$replace['%cat_id%'] 	= $groupCategoryInfo['categoryid'];
		$replace['%cat_name%'] 	= DBSEO::filterText($groupCategoryInfo['title'], NULL, true, true);

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}

	/**
	 * Gets any extra information needed
	 *
	 * @param mixed $socialGroupCategoryIds
	 * 
	 * @return array
	 */
	public static function getInfo($socialGroupCategoryIds)
	{
		$socialGroupCategoryInfo = array();

		if (!is_array($socialGroupCategoryIds))
		{
			// Ensure this is an array
			$socialGroupCategoryIds = array($socialGroupCategoryIds);
		}

		foreach ($socialGroupCategoryIds as $key => $id)
		{
			if (($info = DBSEO::$datastore->fetch('sgcatinfo.' . $id)) === false)
			{
				// We don't have this cached
				continue;
			}

			// We had this cached, cache it internally too
			DBSEO::$cache['socialgroupcategory'][$id] = $info;
		}

		$queryList = array();
		foreach ($socialGroupCategoryIds as $key => $socialGroupCategoryId)
		{
			if (!isset(DBSEO::$cache['socialgroupcategory'][$socialGroupCategoryId]))
			{
				// Ensure this is done
				$queryList[$key] = intval($socialGroupCategoryId);
			}
		}

		if (count($queryList))
		{
			$info = DBSEO::$db->generalQuery('
				SELECT *
				FROM $socialgroupcategory
				WHERE socialgroupcategoryid IN(' . implode(',', $queryList) . ')
			', false);
			foreach ($info as $arr)
			{
				// Build the cache
				DBSEO::$datastore->build('sgcatinfo.' . $arr['socialgroupcategoryid'], $arr);

				// Cache this info
				DBSEO::$cache['socialgroupcategory'][$arr['socialgroupcategoryid']] = $arr;
			}
		}

		if (count($socialGroupCategoryIds) == 1)
		{
			// We have only one, return only one
			$socialGroupCategoryInfo = DBSEO::$cache['socialgroupcategory'][$socialGroupCategoryIds[0]];
		}
		else
		{
			foreach ($socialGroupCategoryIds as $key => $socialGroupCategoryId)
			{
				// Create this array
				$socialGroupCategoryInfo[$socialGroupCategoryId] = DBSEO::$cache['socialgroupcategory'][$socialGroupCategoryId];
			}
		}

		return $socialGroupCategoryInfo;
	}
}

// #############################################################################
// DBSEO "SocialGroupCategory URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupCategory_Page extends DBSEO_Rewrite_SocialGroupCategory
{
	public static $format = 'SocialGroup_SocialGroupCategory_Page';
	public static $structure = 'group.php?cat=%d&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}

// #############################################################################
// DBSEO "SocialGroupHome URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupHome
{
	public static $format = 'SocialGroup_SocialGroupHome';
	public static $structure = 'group.php';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return (is_null($structure) ? self::$structure : $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Handle the replacements
		$newUrl = $rawFormat;

		if (strpos($newUrl, '%') !== false)
		{
			// We should not return true if any single variable remains
			return '';
		}

		// Return the new URL
		return $newUrl;
	}
}


// #############################################################################
// DBSEO "SocialGroupPictureFile URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_SocialGroupPictureFile
{
	public static $format = 'SocialGroup_SocialGroupPictureFile';
	public static $structure = '%s.php?%s=%d%s';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		$moreInfo = '';
		if (intval(DBSEO::$config['templateversion']) == 3)
		{
			if ($urlInfo['group_name'] AND !$urlInfo['group_id'])
			{
				// Reverse group name
				$urlInfo['group_id'] = DBSEO::reverseObject('group', $urlInfo['group_name']);
			}

			// Set group ID
			$moreInfo .= '&groupid=' . $urlInfo['group_id'] . '&dl=' . $match[2];
		}
		else
		{
			// Set dateline
			$moreInfo .= '&d=' . $match[2];
		}

		// Set thumb if we have it
		$moreInfo .= (isset($match[3]) ? '&thumb=1' : '');

		// Check whether this is a thumbnail
		preg_match('#^(\d+)(d\d+)?(t)?#', $urlInfo['picture_id'], $match);

		// Return the constructed URL
		return sprintf((is_null($structure) ? self::$structure : $structure), DBSEO::$config['_picturescript'], DBSEO::$config['_pictureid'], $match[1], $moreInfo);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		if ($data[DBSEO::$config['_pictureid']])
		{
			// Grab group picture info
			$groupPictureInfo = DBSEO::getObjectInfo(DBSEO::$config['_picturestorage'], $data[DBSEO::$config['_pictureid']]);
		}

		if (!$groupPictureInfo['idfield'])
		{
			// group picture didn't exist
			return '';
		}

		// Handle picture id and picture title
		$replace['%picture_id%'] 	= $groupPictureInfo[DBSEO::$config['_pictureid']];
		$replace['%picture_title%'] = DBSEO::filterText($groupPictureInfo['caption']);
		
		if (!$groupPictureInfo['extension'])
		{
			// Ensure we have extension
			$groupPictureInfo['extension'] = pathinfo($groupPictureInfo['filename'], PATHINFO_EXTENSION);
		}

		// Handle extension
		$replace['%original_ext%'] = $groupPictureInfo['extension'];
		if ($data['thumb'])
		{
			// We're requesting a thumbnail
			$replace['%picture_id%'] .= 't';
		}

		$data['groupid'] = ($data['groupid'] ? $data['groupid'] : DBSEO::getContentId($groupPictureInfo));
		if ($data['groupid'])
		{
			// Get group info here
			$groupInfo = DBSEO_Rewrite_SocialGroup::getInfo($data['groupid']);
		}

		if (!$groupInfo['groupid'])
		{
			// Groupid didn't exist
			return '';
		}

		if (!isset($groupInfo['seotitle']))
		{
			$groupInfo['seotitle'] = DBSEO::filterText($groupInfo['name'], NULL, true, (substr($rawFormat, 'group_id') === false));
			if (preg_match('#[-_\s](?:post|print)?\d+$#', $groupInfo['seotitle']) OR !$groupInfo['seotitle'])
			{
				// Append what we need to the title
				$groupInfo['seotitle'] .= ($groupInfo['seotitle'] ? DBSEO::$config['dbtech_dbseo_rewrite_separator'] : '') . 'a';
			}

			// Set this
			DBSEO::$cache['socialgroup'][$groupInfo['groupid']]['seotitle'] = $groupInfo['seotitle'];
		}

		// Handle group info
		$replace['%group_id%'] 		= $groupInfo['groupid'];
		$replace['%group_name%'] 	= $groupInfo['seotitle'];

		if ($data['page'])
		{
			// We had a paged group
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}